/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.dialog.VWParametersDialog;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.steps.IVWSelectParametersParentFrame;
import filenet.vw.toolkit.design.property.steps.VWCaseParameterInfo;
import filenet.vw.toolkit.design.property.steps.VWCasePropertySelectionDialog;
import filenet.vw.toolkit.design.property.steps.VWParameterItem;
import filenet.vw.toolkit.design.property.tables.VWParametersListCellRenderer;
import filenet.vw.toolkit.utils.IVWListUpdateListener;
import filenet.vw.toolkit.utils.IVWMouseActionListener;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWAddRemovePanel;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWMouseAdapter;
import filenet.vw.toolkit.utils.VWPopupMenu;
import filenet.vw.toolkit.utils.VWStepUtils;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.table.VWSortedListModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class VWParametersAddRemovePanel
extends VWAddRemovePanel
implements ActionListener,
IVWMouseActionListener,
IVWListUpdateListener,
IVWPropertyChangeSource {
    private AbstractButton m_advancedButton;
    private AbstractButton m_propertiesButton;
    private AbstractButton m_modeButton;
    private VWPopupMenu m_modePopupMenu;
    private JMenuItem m_readModeMenuItem;
    private JMenuItem m_readWriteModeMenuItem;
    private JMenuItem m_writeModeMenuItem;
    private IVWSelectParametersParentFrame m_parent = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWStepDefinition m_stepDefinition = null;
    private VWParameterItem[] m_availableParameters = null;
    private VWParameterItem[] m_selectedParameters = null;
    private Vector<VWParameterItem> m_tempAvailableParameters = null;
    private Vector<VWParameterItem> m_tempSelectedParameters = null;
    private Vector<VWStepDefinition> m_stepVector = null;

    public VWParametersAddRemovePanel(IVWSelectParametersParentFrame parent, VWAuthPropertyData authPropertyData) {
        super(0);
        this.m_parent = parent;
        this.m_authPropertyData = authPropertyData;
        this.setAvailableItemName(VWResource.s_availableParameters);
        this.setSelectedItemName(VWResource.s_selectedParameters);
        if (this.m_authPropertyData.getDesignerCoreData().getSolutionHelper() == null) {
            this.m_propertiesButton.setVisible(false);
        }
        this.addListUpdateListener(this);
    }

    public void displayFields(boolean display) {
        try {
            this.displayParameters(543, display);
            this.sortLists();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void displayAttachments(boolean display) {
        try {
            this.displayParameters(32, display);
            this.sortLists();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void displayWorkflowGroups(boolean display) {
        try {
            this.displayParameters(64, display);
            this.sortLists();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void displayXMLFields(boolean display) {
        try {
            this.displayParameters(128, display);
            this.sortLists();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void emptyLists() {
        try {
            this.m_availableList.removeAll();
            this.m_selectedList.removeAll();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public String getSelectedParameterName() {
        String paramName = null;
        try {
            VWParameterItem param = (VWParameterItem)this.m_selectedList.getSelectedValue();
            if (param != null) {
                paramName = param.getName();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return paramName;
    }

    public String[] getSelectedParameterNames() {
        String[] paramNames = null;
        try {
            Object[] items = this.m_selectedList.getSelectedValues();
            if (items != null) {
                paramNames = new String[items.length];
                for (int i = 0; i < items.length; ++i) {
                    paramNames[i] = ((VWParameterItem)items[i]).getName();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return paramNames;
    }

    public boolean isSelected(String itemName) {
        boolean result;
        block3: {
            result = false;
            try {
                VWSortedListModel selectedListModel = (VWSortedListModel)this.m_selectedList.getModel();
                int selectedListSize = selectedListModel.getSize();
                if (selectedListSize <= 0) break block3;
                for (int i = 0; i < selectedListSize; ++i) {
                    VWParameterItem param = (VWParameterItem)selectedListModel.get(i);
                    String name = param.getName();
                    if (VWStringUtils.compare(itemName, name) != 0) continue;
                    result = true;
                    break;
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        return result;
    }

    public void setSelectedStep(VWStepDefinition stepDefinition) {
        try {
            this.m_stepDefinition = stepDefinition;
            if (this.m_stepDefinition != null && this.m_authPropertyData != null) {
                VWFieldDefinition[] fieldDefs;
                this.m_availableParameters = null;
                this.m_selectedParameters = null;
                Vector<VWParameterItem> availableParams = new Vector<VWParameterItem>();
                if (VWStepUtils.getStepType(this.m_stepDefinition) == 0) {
                    VWFieldDefinition fieldDef = this.m_authPropertyData.getField("F_Trackers");
                    if (fieldDef != null) {
                        availableParams.addElement(new VWParameterItem(fieldDef.getName(), fieldDef, null));
                    }
                    if ((fieldDef = this.m_authPropertyData.getField("F_CaseFolder")) != null) {
                        availableParams.addElement(new VWParameterItem(fieldDef.getName(), fieldDef, null));
                    }
                    if ((fieldDef = this.m_authPropertyData.getField("F_CaseTask")) != null) {
                        availableParams.addElement(new VWParameterItem(fieldDef.getName(), fieldDef, null));
                    }
                }
                if ((fieldDefs = this.m_authPropertyData.getFields()) != null && fieldDefs.length > 0) {
                    for (int i = 0; i < fieldDefs.length; ++i) {
                        availableParams.addElement(new VWParameterItem(fieldDefs[i].getName(), fieldDefs[i], null));
                    }
                }
                if (availableParams.size() > 0) {
                    this.m_availableParameters = new VWParameterItem[availableParams.size()];
                    availableParams.copyInto(this.m_availableParameters);
                }
                this.m_selectedParameters = this.getSelectedParameters();
                this.reinitialize();
            } else {
                this.emptyLists();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseReferences() {
        this.m_availableParameters = null;
        this.m_selectedParameters = null;
        this.m_tempAvailableParameters = null;
        this.m_tempSelectedParameters = null;
        this.removeListUpdateListener(this);
        if (this.m_modeButton != null) {
            this.m_modeButton.removeActionListener(this);
            this.m_modeButton = null;
        }
        super.removeReferences();
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource().equals(this.m_advancedButton)) {
                this.performEditParametersAction();
            } else if (event.getSource().equals(this.m_propertiesButton)) {
                this.performEditCasePropertiesAction();
            } else if (event.getSource().equals(this.m_modeButton) && this.m_modeButton.isEnabled()) {
                this.displayModePopup(this.m_modeButton, 10, 10);
            } else if (event.getSource().equals(this.m_readModeMenuItem)) {
                this.updateMode(1);
            } else if (event.getSource().equals(this.m_readWriteModeMenuItem)) {
                this.updateMode(3);
            } else if (event.getSource().equals(this.m_writeModeMenuItem)) {
                this.updateMode(2);
            } else {
                super.actionPerformed(event);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(JOptionPane.getFrameForComponent(this.m_parentContainer), ex.getLocalizedMessage(), 1);
        }
    }

    public void createPopup(MouseEvent event) {
        if (event.getSource().equals(this.m_selectedList)) {
            Object[] selectedItems = this.m_selectedList.getSelectedValues();
            if (selectedItems == null || selectedItems.length == 0) {
                return;
            }
            this.displayModePopup(event.getComponent(), event.getX(), event.getY());
        }
    }

    public void listUpdated(Object source, int nEventType, Object[] items) {
        try {
            VWParameterItem param = null;
            if (items != null && items.length == 1 && items[0] instanceof VWParameterItem) {
                param = (VWParameterItem)items[0];
            }
            switch (nEventType) {
                case 5: {
                    this.m_parent.updateAvailableParameterProperties(param);
                    break;
                }
                case 6: {
                    this.m_parent.updateSelectedParameterProperties(param);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void notifyPropertyChange() {
    }

    public Vector getItemsChanged() {
        return this.m_stepVector;
    }

    public void initializeLists(Object[] availableItems, Object[] selectedItems) {
        try {
            if (this.m_enableTypeAhead && this.m_typeAheadName != null) {
                this.m_typeAheadName.setText("");
                this.m_typeAheadName.requestFocus();
            }
            this.setSelectedItems(selectedItems);
            this.setAvailableItems(availableItems, selectedItems);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected JPanel createSelectedListPanel() {
        try {
            JPanel sListPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(0, 3, 3, 20);
            sListPanel.add((Component)this.m_selectedLabel, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_selectedLabel, this, this.m_selectedLabel.getText(), this.m_selectedLabel.getText());
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.insets = new Insets(0, 0, 0, 0);
            String label = VWResource.s_ellipse.toString(VWResource.s_businessObjects);
            this.m_propertiesButton = VWImageLoader.createToolBarButton("exposedfields.gif", label, false);
            this.m_propertiesButton.addActionListener(this);
            sListPanel.add((Component)this.m_propertiesButton, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_propertiesButton, this, label, label);
            ++gbCons.gridx;
            this.m_advancedButton = VWImageLoader.createToolBarButton("update.gif", VWResource.s_advancedDots, false);
            this.m_advancedButton.addActionListener(this);
            sListPanel.add((Component)this.m_advancedButton, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_advancedButton, this, VWResource.s_advancedDots, VWResource.s_advancedDots);
            ++gbCons.gridx;
            this.m_modeButton = VWImageLoader.createToolBarButton("popup.gif", VWResource.s_accessRights, false);
            this.m_modeButton.setEnabled(false);
            this.m_modeButton.addActionListener(this);
            sListPanel.add((Component)this.m_modeButton, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_modeButton, this, VWResource.s_accessRights, VWResource.s_accessRights);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            gbCons.gridwidth = 0;
            gbCons.insets = new Insets(0, 3, 0, 3);
            this.m_selectedList = new JList(new VWSortedListModel());
            this.m_selectedList.addListSelectionListener(this);
            this.m_selectedList.addMouseListener(new VWMouseAdapter(this));
            this.m_selectedList.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_selectedList.addFocusListener(this);
            sListPanel.add((Component)new JScrollPane(this.m_selectedList), gbCons);
            VWAccessibilityHelper.setLabelFor(this.m_selectedLabel, this.m_selectedList);
            VWAccessibilityHelper.setAccessibility(this.m_selectedList, sListPanel, this.m_selectedLabel.getText(), this.m_selectedLabel.getText());
            return sListPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected void updateTheMainButtonsState() {
        int[] selectedIndices = this.m_selectedList.getSelectedIndices();
        if (this.m_modeButton != null) {
            this.m_modeButton.setEnabled(selectedIndices.length > 0);
            this.m_modeButton.setFocusable(this.m_modeButton.isEnabled());
        }
        super.updateTheMainButtonsState();
    }

    protected void onAddItemsAction(Object[] items) {
        try {
            if (this.m_stepDefinition != null) {
                for (int i = 0; i < items.length; ++i) {
                    VWParameterItem param = (VWParameterItem)items[i];
                    VWFieldDefinition fieldDef = param.getFieldDefinition();
                    String paramName = param.getName();
                    String paramValue = fieldDef.getName();
                    VWParameterDefinition paramDef = this.m_stepDefinition.createParameter(paramName, 3, paramValue, fieldDef.getFieldType(), fieldDef.isArray());
                    paramDef.setDescription(fieldDef.getDescription());
                    param.setParameterDefinition(paramDef);
                }
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected boolean okayToRemoveItem(Object item) {
        try {
            VWParameterItem parameterItem = (VWParameterItem)item;
            VWParameterDefinition vwParameterDef = parameterItem.getParameterDefinition();
            if (vwParameterDef != null && VWStringUtils.compare(vwParameterDef.getName(), vwParameterDef.getValue()) != 0) {
                String message = VWResource.s_deleteExpressionParameter.toString(parameterItem.getName());
                int nConfirmResult = VWMessageDialog.showConfirmDialog(this.m_authPropertyData.getMainContainer(), message, VWResource.s_warning, 3);
                if (nConfirmResult == 2) {
                    return false;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return true;
    }

    protected Object[] onRemoveItemsAction(Object[] items) {
        Object[] newItems = null;
        try {
            if (this.m_stepDefinition != null) {
                ArrayList<VWParameterDefinition> deletedParams = new ArrayList<VWParameterDefinition>();
                ArrayList<VWParameterItem> availableFields = new ArrayList<VWParameterItem>();
                for (int i = 0; i < items.length; ++i) {
                    VWParameterItem parameterItem = (VWParameterItem)items[i];
                    String paramName = parameterItem.getName();
                    deletedParams.add(parameterItem.getParameterDefinition());
                    parameterItem.setParameterDefinition(null);
                    this.m_stepDefinition.deleteParameter(paramName);
                    if (!this.m_authPropertyData.isFieldName(paramName)) continue;
                    availableFields.add(parameterItem);
                }
                newItems = new Object[availableFields.size()];
                availableFields.toArray(newItems);
                VWCaseParameterInfo.removePostAssignments(deletedParams.toArray(new VWParameterDefinition[0]), this.m_stepDefinition);
                this.m_stepVector = new Vector();
                this.m_stepVector.addElement(this.m_stepDefinition);
                this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 553);
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return newItems;
    }

    private void reinitialize() {
        try {
            this.initializeLists(this.m_availableParameters, this.m_selectedParameters);
            this.setListCellRenderer(new VWParametersListCellRenderer());
            this.m_tempAvailableParameters = new Vector();
            this.m_tempSelectedParameters = new Vector();
            VWSortedListModel listModel = (VWSortedListModel)this.m_availableList.getModel();
            if (listModel != null && listModel.getSize() > 0) {
                this.m_availableList.setSelectedIndex(0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void sortLists() {
        try {
            VWSortedListModel availableListModel = (VWSortedListModel)this.m_availableList.getModel();
            VWSortedListModel selectedListModel = (VWSortedListModel)this.m_selectedList.getModel();
            if (availableListModel != null) {
                availableListModel.sort();
            }
            if (selectedListModel != null) {
                selectedListModel.sort();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void displayParameters(int parameterType, boolean display) {
        VWParameterItem param = null;
        int fieldType = 0;
        try {
            VWSortedListModel availableListModel = (VWSortedListModel)this.m_availableList.getModel();
            VWSortedListModel selectedListModel = (VWSortedListModel)this.m_selectedList.getModel();
            if (display) {
                int i;
                if (this.m_tempAvailableParameters != null) {
                    int tempAvailableParametersSize = this.m_tempAvailableParameters.size();
                    for (i = tempAvailableParametersSize - 1; i >= 0; --i) {
                        param = this.m_tempAvailableParameters.get(i);
                        if (param == null || ((fieldType = param.getFieldDefinition().getFieldType()) & parameterType) == 0) continue;
                        availableListModel.addElement(param);
                        this.m_tempAvailableParameters.removeElementAt(i);
                    }
                }
                if (this.m_tempSelectedParameters != null) {
                    int tempSelectedParametersSize = this.m_tempSelectedParameters.size();
                    for (i = tempSelectedParametersSize - 1; i >= 0; --i) {
                        param = this.m_tempSelectedParameters.get(i);
                        if (param == null || ((fieldType = param.getParameterDefinition().getDataType()) & parameterType) == 0) continue;
                        selectedListModel.addElement(param);
                        this.m_tempSelectedParameters.removeElementAt(i);
                    }
                }
            } else {
                int selectedListSize;
                int availableListSize = availableListModel.getSize();
                if (availableListSize > 0) {
                    for (int i = availableListSize - 1; i >= 0; --i) {
                        param = (VWParameterItem)availableListModel.get(i);
                        if (param == null || ((fieldType = param.getFieldDefinition().getFieldType()) & parameterType) == 0) continue;
                        this.m_tempAvailableParameters.add(param);
                        availableListModel.removeElementAt(i);
                    }
                    this.m_availableList.clearSelection();
                }
                if ((selectedListSize = selectedListModel.getSize()) > 0) {
                    for (int i = selectedListSize - 1; i >= 0; --i) {
                        param = (VWParameterItem)selectedListModel.get(i);
                        if (param == null || ((fieldType = param.getParameterDefinition().getDataType()) & parameterType) == 0) continue;
                        this.m_tempSelectedParameters.add(param);
                        selectedListModel.removeElementAt(i);
                    }
                    this.m_selectedList.clearSelection();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private VWParameterItem[] getSelectedParameters() {
        VWParameterItem[] paramItems = null;
        try {
            VWParameterDefinition[] paramDefs;
            if (this.m_stepDefinition != null && this.m_authPropertyData != null && (paramDefs = this.m_stepDefinition.getParameterDefinitions()) != null && paramDefs.length > 0) {
                paramItems = new VWParameterItem[paramDefs.length];
                for (int nIndex = 0; nIndex < paramDefs.length; ++nIndex) {
                    String paramName = paramDefs[nIndex].getName();
                    paramItems[nIndex] = this.m_authPropertyData.isFieldName(paramName) ? new VWParameterItem(paramName, this.m_authPropertyData.getField(paramName), this.m_stepDefinition.getParameterDefinition(paramName)) : new VWParameterItem(paramName, null, this.m_stepDefinition.getParameterDefinition(paramName));
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return paramItems;
    }

    private void setSelectedItems(Object[] items) {
        VWSortedListModel listModel = null;
        try {
            if (this.m_bShowUpDownButtons) {
                this.m_moveUpButton.setEnabled(false);
                this.m_moveDownButton.setEnabled(false);
            }
            listModel = new VWSortedListModel();
            if (items != null) {
                for (int i = 0; i < items.length; ++i) {
                    listModel.addElement(items[i]);
                }
            }
            if (this.m_bSortSelected) {
                listModel.sort();
            }
            this.m_selectedList.setModel(listModel);
            this.updateTheAllButtonsState();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void setAvailableItems(Object[] availableItems, Object[] selectedItems) {
        VWSortedListModel listModel = null;
        try {
            this.m_addButton.setEnabled(false);
            this.m_removeButton.setEnabled(false);
            listModel = new VWSortedListModel();
            if (availableItems != null) {
                if (selectedItems == null) {
                    for (int i = 0; i < availableItems.length; ++i) {
                        listModel.addElement(availableItems[i]);
                    }
                } else {
                    for (int i = 0; i < availableItems.length; ++i) {
                        if (this.isInArray(availableItems[i], selectedItems)) continue;
                        listModel.addElement(availableItems[i]);
                    }
                }
            }
            if (this.m_bSortAvailable) {
                listModel.sort();
            }
            this.m_availableList.setModel(listModel);
            this.updateTheAllButtonsState();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private boolean isInArray(Object item, Object[] items) {
        String itemName = null;
        if (item == null || items == null) {
            return false;
        }
        itemName = item.toString();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || VWStringUtils.compareIgnoreCase(itemName, items[i].toString()) != 0) continue;
            return true;
        }
        return false;
    }

    private void performEditParametersAction() throws VWException {
        VWParametersDialog parametersDlg = new VWParametersDialog(this.m_authPropertyData.getMainContainer(), this.m_authPropertyData, this.m_stepDefinition);
        parametersDlg.init();
        parametersDlg.setVisible(true);
        this.updatePostAssignments(this.m_stepDefinition.getParameterDefinitions());
        this.setSelectedStep(this.m_stepDefinition);
    }

    private void performEditCasePropertiesAction() {
        VWCasePropertySelectionDialog parametersDlg = new VWCasePropertySelectionDialog(this.m_authPropertyData.getMainContainer(), this.m_authPropertyData);
        parametersDlg.initialize(this.m_stepDefinition);
        parametersDlg.setVisible(true);
        if (parametersDlg.getExitStatus() == 0) {
            this.m_stepVector = null;
            this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 511);
            this.m_stepVector = new Vector();
            this.m_stepVector.addElement(this.m_stepDefinition);
            this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 553);
        }
    }

    private void updateMode(int newMode) throws VWException {
        Object[] selectedItems = this.m_selectedList.getSelectedValues();
        if (selectedItems != null) {
            ArrayList<VWParameterDefinition> paramDefList = new ArrayList<VWParameterDefinition>();
            for (int i = 0; i < selectedItems.length; ++i) {
                VWParameterDefinition paramDef = ((VWParameterItem)selectedItems[i]).getParameterDefinition();
                paramDef.setMode(newMode);
                paramDefList.add(paramDef);
            }
            if (paramDefList.size() > 0) {
                this.updatePostAssignments(paramDefList.toArray(new VWParameterDefinition[0]));
            }
            this.m_selectedList.repaint();
        }
    }

    private void updatePostAssignments(VWParameterDefinition[] parameterDefs) {
        try {
            String[] guidFieldNames = VWCaseParameterInfo.getGuidFieldNames(this.m_authPropertyData);
            if (guidFieldNames == null || guidFieldNames.length == 0) {
                return;
            }
            HashMap<String, ArrayList<VWCaseParameterInfo>> selectedPropertyMap = VWCaseParameterInfo.getSelectedProperties(guidFieldNames, parameterDefs);
            if (selectedPropertyMap != null) {
                boolean bNotifyListeners = false;
                Iterator<Map.Entry<String, ArrayList<VWCaseParameterInfo>>> mapIterator = selectedPropertyMap.entrySet().iterator();
                while (mapIterator.hasNext()) {
                    ArrayList<VWParameterDefinition> paramDefList = new ArrayList<VWParameterDefinition>();
                    Map.Entry<String, ArrayList<VWCaseParameterInfo>> mapEntry = mapIterator.next();
                    ArrayList<VWCaseParameterInfo> caseParamList = mapEntry.getValue();
                    for (int i = 0; i < caseParamList.size(); ++i) {
                        VWCaseParameterInfo paramInfo = caseParamList.get(i);
                        if (paramInfo == null) continue;
                        paramDefList.add(paramInfo.getParameterDefinition());
                    }
                    if (paramDefList.size() <= 0) continue;
                    parameterDefs = paramDefList.toArray(new VWParameterDefinition[0]);
                    VWCaseParameterInfo.updatePostAssignments(mapEntry.getKey(), this.m_stepDefinition, this.m_authPropertyData, parameterDefs);
                    bNotifyListeners = true;
                }
                if (bNotifyListeners) {
                    this.m_stepVector = null;
                    this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 511);
                    this.m_stepVector = new Vector();
                    this.m_stepVector.addElement(this.m_stepDefinition);
                    this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 553);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(JOptionPane.getFrameForComponent(this.m_parentContainer), ex.getLocalizedMessage(), 1);
        }
    }

    private void displayModePopup(Component component, int x, int y) {
        if (this.m_modePopupMenu == null) {
            this.m_modePopupMenu = new VWPopupMenu();
            this.m_modePopupMenu.removeAll();
            this.m_readModeMenuItem = new JMenuItem(VWResource.s_read);
            this.m_readModeMenuItem.addActionListener(this);
            this.m_modePopupMenu.add(this.m_readModeMenuItem);
            this.m_readWriteModeMenuItem = new JMenuItem(VWResource.s_readAndWrite);
            this.m_readWriteModeMenuItem.addActionListener(this);
            this.m_modePopupMenu.add(this.m_readWriteModeMenuItem);
            this.m_writeModeMenuItem = new JMenuItem(VWResource.s_write);
            this.m_writeModeMenuItem.addActionListener(this);
            this.m_modePopupMenu.add(this.m_writeModeMenuItem);
        }
        this.m_modePopupMenu.applyComponentOrientation(this.getComponentOrientation());
        this.m_modePopupMenu.show(component, x, y);
    }
}

